/*****************************************************************************
*  LPC11U6x SCT PWM Reload program
*
*  Use the match reload registers to change the duty cycle of two PWM
*  signals and maintain their dead-time intervals using the NORELOAD_L bit
*  in the SCT Configuration register
*****************************************************************************/
#include "board.h"

#define DC1        (130)                                   			// duty cycle 1
#define DC2        (135)                                   			// duty cycle 2
#define hperiod    (180)

void SCT1_Init(void);

void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);			                  		 		// enable the SCT1 clock

	Chip_SCT_Config(LPC_SCT1, SCT_CONFIG_16BIT_COUNTER |				// split timers, auto limit
							  SCT_CONFIG_AUTOLIMIT_L   );

	Chip_SCT_SetControl(LPC_SCT1, SCT_CTRL_BIDIR_L(1));     			// configure SCT1 as BIDIR

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_0, hperiod);				// match on (half) PWM period
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, hperiod);

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_1, DC1);					// match on duty cycle 1
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_1, DC1);

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_2, DC2);					// match on duty cycle 2
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_2, DC2);

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_ALL_STATES);	 	// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0,  (CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH1 |
                                                                          SCT_COMBMODE_MATCH ));	// match 1 (DC1) only condition

	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_1, ENABLE_ALL_STATES);	 	// event 1 happens in all states
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_1,(CHIP_SCT_EVENTCTRL_T)  ( SCT_EVECTRL_MATCH2 |
                                                                        SCT_COMBMODE_MATCH )); 	// match 2 (DC) only condition

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_0);				// event 0 set OUT0 (blue LED)
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_0);			//  event 0 clears OUT0 (blue LED)

	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_1, SCT_EVT_1);				// event 1 sets OUT1 (red LED)
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_1, SCT_EVT_1); 			// event 1 clear OUT1 (red LED)

	Chip_SCT_SetConflictResolution(LPC_SCT1, 0,SCT_RES_TOGGLE_OUTPUT);  // toggle OUT0 and OUT1 on conflict

	Chip_SCT_Output(LPC_SCT1, 0x01);                   					// default set OUT0 and and clear OUT1


	Chip_SCT_ClearControl(LPC_SCT1,SCT_CTRL_HALT_L);	   				// unhalt it by clearing bit 2 of the CTRL register

}




void SysTick_Handler(void)
{

	Chip_SCT_SetControl(LPC_SCT1, SCT_CONFIG_NORELOADL_U);			// stop reload process for L counter

    if (Chip_GPIO_GetPinState(LPC_GPIO, 0, 16))              		// P0_16 high?
    {
        if (LPC_SCT1->MATCHREL[2].L < hperiod-1)        			// check if DC2 < Period of PWM
        {
            LPC_SCT1->MATCHREL[1].L ++;
            LPC_SCT1->MATCHREL[2].L ++;
        }
    }
    else if (LPC_SCT1->MATCHREL[1].L > 1)              				// check if DC1 > 1
    {
        LPC_SCT1->MATCHREL[1].L --;
        LPC_SCT1->MATCHREL[2].L --;
    }
    LPC_SCT1->CONFIG &= ~(1 << 7);                     				// enable reload process for L counter
}


int main (void)
{

	SystemCoreClockUpdate();
	Board_Init();


	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);				// enable clock for IOCON



	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,16 , 0x00000081);				// P2_16 is SCT1_OUT0
	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,17 , 0x00000081);				// P2_17 is SCT1_OUT1


	SysTick_Config(SystemCoreClock/50);                				// SysTick interrupt @ 50 Hz = 20 msec


	SCT1_Init();                                   					// Initialize SCT


	while (1)                                              			// loop forever
	{
		__WFI();
	}
}

